#include "BinSolver.h"
#include "global.h"


#include<stdio.h>
#include<string.h>

/*  solvers=["kcnfs04SAT07", "march_dl2004", "minisat20SAT07", "rsat20", "vallst", "
zchaff_rand", "tts", "picosat846", "mxc08", "march_pl", "ranov", "adaptg2wsat0",
 "adaptg2wsatplus", "gnoveltyplus", "SATenstein_hgen", "SATenstein_r3sat", "SATe
nstein_qcp", "SATenstein_swgcp"]
*/


BinSolver* binSolvers[13];
int NUM_ALGS = 13;

void ClearSolvers() {
	for(int i=0; i<13; i++)
		delete binSolvers[i];
}

void BuildSolvers(char* strseed)
{
  // kcnfs04SAT07
  binSolvers[0]=new BinSolver ("kcnfs04SAT07", 2, 1);
  binSolvers[0]->argv[2] = NULL;

  // march_dl2004
  binSolvers[1]=new BinSolver ("march_dl2004", 2, 1);
  binSolvers[1]->argv[2] = NULL;

  // minisat20SAT07
  binSolvers[2]=new BinSolver ("minisat20SAT07", 2, 1);
  binSolvers[2]->argv[2] = NULL;

  // minisat20SAT07
  binSolvers[3]=new BinSolver ("minisat20", 3, 1);
  binSolvers[3]->argv[2] = "foo";
  binSolvers[3]->argv[3] = NULL;
 
  //vallst
  binSolvers[4]=new BinSolver ("vallst", 4, 1);
  binSolvers[4]->argv[2] = "-o";
  binSolvers[4]->argv[3] = "-";
  binSolvers[4]->argv[4] = NULL;

  // -- zchaff_rand
  binSolvers[5]=new BinSolver ("zchaff_rand", 3, 1);
  binSolvers[5]->argv[2] = strseed;
  binSolvers[5]->argv[3] = NULL;

  // -- tts
  binSolvers[6]=new BinSolver ("tts-4-0", 2, 1);
  binSolvers[6]->argv[2] = NULL;

  // -- picosat846
  binSolvers[7]=new BinSolver ("picosat846", 2, 1);
  binSolvers[7]->argv[2] = NULL;

  // -- mxc08
  binSolvers[8]=new BinSolver ("mxc-sr08", 3, 1);
  binSolvers[8]->argv[2]="-i";
  binSolvers[8]->argv[3] = NULL;

  // -- adaptg2wsat0
  binSolvers[9]=new BinSolver ("adaptg2wsat0", 3, 1);
  binSolvers[9]->argv[2] = strseed;
  binSolvers[9]->argv[3] = NULL;

  // -- adaptg2wsat+
  binSolvers[10]=new BinSolver ("adaptg2wsat+", 3, 1);
  binSolvers[10]->argv[2] = strseed;
  binSolvers[10]->argv[3] = NULL;

  // -- gnoveltyplus
  binSolvers[11]=new BinSolver ("gnovelty+", 3, 1);
  binSolvers[11]->argv[2] = strseed;
  binSolvers[11]->argv[3] = NULL;
 
// SATenstein qcp
  binSolvers[12]=new BinSolver ("SATenstein", 33, 2);
  binSolvers[12]->argv[1] = "-inst";
  binSolvers[12]->argv[3] = "-alg";
  binSolvers[12]->argv[4] = "satenstein";
  binSolvers[12]->argv[5] = "-singleclause";
  binSolvers[12]->argv[6] = "1";
  binSolvers[12]->argv[7] = "-randomwalk";
  binSolvers[12]->argv[8] = "4";
  binSolvers[12]->argv[9] = "-performrandomwalk";
  binSolvers[12]->argv[10] = "1";
  binSolvers[12]->argv[11] = "-heuristic";
  binSolvers[12]->argv[12] = "5";
  binSolvers[12]->argv[13] = "-clausepen";
  binSolvers[12]->argv[14] = "0";
  binSolvers[12]->argv[15] = "-selectclause";
  binSolvers[12]->argv[16] = "1";
  binSolvers[12]->argv[17] = "-promisinglist";
  binSolvers[12]->argv[18] = "0";
  binSolvers[12]->argv[19] = "-adaptive";
  binSolvers[12]->argv[20] = "0";
  binSolvers[12]->argv[21]= "-rfp";
  binSolvers[12]->argv[22]= "0.07";
  binSolvers[12]->argv[23] ="-tabusearch";
  binSolvers[12]->argv[24]= "0";
  binSolvers[12]->argv[25] = "-scoringmeasure";
  binSolvers[12]->argv[26] = "1";
  binSolvers[12]->argv[27] = "-cutoff";
  binSolvers[12]->argv[28] = "max";
  binSolvers[12]->argv[29] = "-seed";
  binSolvers[12]->argv[30] = "0";
  binSolvers[12]->argv[31] = "-r";
  binSolvers[12]->argv[32] = "satcomp";
  binSolvers[12]->argv[33] = NULL;  
}
