#include <qdir.h>
#include <qtextstream.h>
#include <qstring.h>
#include "fileview.h"

FileView::FileView(QString file_name, QWidget *parent) : QWidget(parent)
{
    setupUi(this);

    QDir dir("workspace");
    QDir current;
    QString relative_path;

    relative_path = current.relativeFilePath(QString("workspace/"+file_name));
    QFile file(relative_path);

    if (!file.open(QIODevice::ReadOnly))
    {
        close();

        return;
    }

    QTextStream input(&file);

    setWindowTitle(windowTitle()+file_name);

    while(!input.atEnd())
    {
        QString line;

        line = input.readLine();
        textEdit->append(line);
    }

    textEdit->moveCursor(QTextCursor::Start);
    setWindowFlags(windowFlags() & ~Qt::WindowContextHelpButtonHint);
    show();
}

//
